%------------------------------------------------------------------------------
% File     : LCL609^1 : TPTP v7.4.0. Released v3.6.0.
% Domain   : Logical Calculi
% Problem  : LAMBDA^mm_1 validates the generalization rule
% Version  : [BP09] axioms.
% English  :

% Refs     : [BP09]  Benzmueller & Paulson (2009), Exploring Properties of
% Source   : [BP09]
% Names    : NL_6 [BP09]

% Status   : Theorem
% Rating   : 0.00 v6.0.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v4.1.0, 0.00 v4.0.0, 0.33 v3.7.0
% Syntax   : Number of formulae    :   36 (   0 unit;  20 type;  15 defn)
%            Number of atoms       :   84 (  15 equality;  44 variable)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   41 (   3   ~;   1   |;   2   &;  33   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   81 (  81   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   25 (  20   :;   0   =)
%            Number of variables   :   39 (   2 sgn;   6   !;   4   ?;  29   ^)
%                                         (  39   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
%----Include simple maths definitions and axioms
include('Axioms/LCL008^0.ax').
%------------------------------------------------------------------------------
%----Conjecture
thf(thm,conjecture,(
    ! [P: individuals > $i > $o] :
      ( ! [X: individuals] :
          ( mvalid @ ( P @ X ) )
     => ( mvalid
        @ ( mall
          @ ^ [X: individuals] :
              ( P @ X ) ) ) ) )).

%------------------------------------------------------------------------------
